jQuery(document).ready(function($) {
    $('.nav-tab-wrapper a').click(function(e) { e.preventDefault(); $('.nav-tab').removeClass('nav-tab-active'); $(this).addClass('nav-tab-active'); $('.digi-tab').hide(); $($(this).attr('href')).show(); });
    $('#cb-all-plugins').change(function(){ $('#tab-plugins .cb').prop('checked', $(this).is(':checked')); });
    $('#cb-all-themes').change(function(){ $('#tab-themes .cb').prop('checked', $(this).is(':checked')); });

    $('#btn-check-plugins, #btn-check-themes').click(function() {
        var rows = $(this).closest('.digi-tab').find('tbody tr').has('input:checked');
        if(!rows.length) return alert('Chọn ít nhất 1 mục');
        var q = rows.toArray();
        var run = function() {
            if(!q.length) return;
            var r = $(q.shift());
            r.find('.col-status').html('Checking...');
            $.post(digi_vars.ajax_url, {
                action: 'digi_check_item', nonce: digi_vars.nonce, slug: r.data('slug'), type: r.data('type'), current_version: r.data('ver')
            }, function(res) {
                if(res.success) {
                    r.find('.col-server').text(res.data.new);
                    if(res.data.has_update) { r.addClass('has-update').data('pkg', res.data.pkg); r.find('.col-status').html('<b style="color:red">Update Available</b>'); }
                    else { r.find('.col-status').html('<span style="color:green">Latest</span>'); }
                } else { r.find('.col-status').text(res.data); }
                run();
            });
        };
        run();
        $('#btn-update-plugins, #btn-update-themes').removeAttr('disabled');
    });

    $('#btn-update-plugins, #btn-update-themes').click(function() {
        var rows = $(this).closest('.digi-tab').find('tr.has-update').has('input:checked');
        if(!rows.length) return alert('Chọn mục có bản mới để update');
        $('#progress-area').show();
        var q = rows.toArray(), total = q.length, done = 0;
        var run = function() {
            if(!q.length) return $('#progress-area .bar').text('Done!');
            var r = $(q.shift());
            r.find('.col-status').text('Updating...');
            $.post(digi_vars.ajax_url, {
                action: 'digi_update_item', nonce: digi_vars.nonce, slug: r.data('slug'), type: r.data('type'), package_url: r.data('pkg')
            }, function(res) {
                done++; $('#progress-area .bar').css('width', (done/total)*100+'%').text(Math.floor((done/total)*100)+'%');
                if(res.success) { r.removeClass('has-update').css('background','#e7f7d3').find('.col-status').text('Success'); r.find('.cb').prop('checked',false); }
                else { r.find('.col-status').text('Failed'); }
                run();
            });
        };
        run();
    });
});