<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Digi_Client_Dashboard {
    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'assets' ) );
        add_action( 'admin_init', array( $this, 'settings' ) );
        add_action( 'wp_ajax_digi_check_item', array( $this, 'check_item' ) );
        add_action( 'wp_ajax_digi_update_item', array( $this, 'update_item' ) );
		add_filter( 'plugin_action_links_' . DIGI_CLIENT_BASENAME, array( $this, 'settings_link' ) , 10, 2);
    }

    public function add_menu() { add_dashboard_page( 'Digi Manager', 'Digi Manager', 'manage_options', 'digi-manager', array( $this, 'view' ) ); }
	public function settings_link ($links) {
		$url = admin_url( 'index.php?page=digi-manager' );
        $settings_link = '<a href="' . esc_url( $url ) . '">Cài đặt</a>';
        array_unshift( $links, $settings_link );
		return $links;
	}
    public function settings() { register_setting( 'digi_client_group', 'digi_client_license_key' ); }
    
    public function assets( $hook ) {
        if ( strpos( $hook, 'digi-manager' ) === false ) return;
        wp_enqueue_style( 'digi-client-css', plugins_url( '../assets/css/client-style.css', __FILE__ ) );
        wp_enqueue_script( 'digi-client-js', plugins_url( '../assets/js/client-script.js', __FILE__ ), array('jquery'), '1.1', true );
        wp_localize_script( 'digi-client-js', 'digi_vars', array( 'ajax_url' => admin_url('admin-ajax.php'), 'nonce' => wp_create_nonce('digi_update_nonce') ) );
    }

    private function get_status($license) {
        if ( empty($license) ) return 'missing';
        $res = wp_remote_post( Digi_Client_Config::get_api_url(), array( 'body' => array('action'=>'get_status', 'license'=>$license, 'domain'=>home_url()), 'timeout'=>10 ) );
        if ( is_wp_error($res) ) return 'error';
        $data = json_decode( wp_remote_retrieve_body($res) );
        return isset($data->status) ? $data->status : 'unknown';
    }

    public function view() {
        $license = get_option( 'digi_client_license_key' );
        $status = $this->get_status($license);
        
        $badges = array(
            'active' => '<span class="digi-badge status-active">Đang hoạt động</span>',
            'inactive' => '<span class="digi-badge status-inactive">Đã bị tắt</span>',
            'blocked' => '<span class="digi-badge status-blocked">Bị khóa (Vi phạm IP)</span>',
            'missing' => '<span class="digi-badge status-missing">Chưa nhập Key</span>',
            'error' => '<span class="digi-badge status-error">Lỗi kết nối</span>',
            'invalid' => '<span class="digi-badge status-blocked">License Sai</span>'
        );
        $badge = isset($badges[$status]) ? $badges[$status] : $badges['error'];
        ?>
        <div class="wrap digi-updater-wrap">
            <h1>Digi Client Updater</h1>
            <div class="digi-box">
                <h3>Thông tin Bản quyền <?php echo $badge; ?></h3>
                <form method="post" action="options.php">
                    <?php settings_fields( 'digi_client_group' ); ?>
                    <input name="digi_client_license_key" type="text" value="<?php echo esc_attr( $license ); ?>" class="regular-text" placeholder="License Key">
                    <?php submit_button('Save'); ?>
                </form>
            </div>
            
            <?php if ( $status === 'active' ) : 
                $plugins = get_plugins(); $themes = wp_get_themes(); ?>
                <div class="digi-box">
                    <h2 class="nav-tab-wrapper">
                        <a href="#tab-plugins" class="nav-tab nav-tab-active">Plugins</a>
                        <a href="#tab-themes" class="nav-tab">Themes</a>
                    </h2>
                    <div id="progress-area" style="display:none; margin:10px 0;"><div class="bar" style="background:#2271b1; height:20px; width:0%; color:#fff; text-align:center;">0%</div></div>
                    
                    <div id="tab-plugins" class="digi-tab">
                        <p><button class="button button-primary" id="btn-check-plugins">Kiểm tra</button> <button class="button" id="btn-update-plugins" disabled>Cập nhật</button></p>
                        <table class="wp-list-table widefat fixed striped">
                            <thead><tr><td class="check-column"><input type="checkbox" id="cb-all-plugins"></td><th>Tên</th><th>Version</th><th>Server</th><th>Status</th></tr></thead>
                            <tbody>
                            <?php foreach($plugins as $p => $d): $slug = (dirname($p)=='.')?basename($p,'.php'):dirname($p); ?>
                                <tr class="item-row" data-type="plugin" data-slug="<?php echo $slug; ?>" data-file="<?php echo $p; ?>" data-ver="<?php echo $d['Version']; ?>">
                                    <th class="check-column"><input type="checkbox" class="cb"></th>
                                    <td><strong><?php echo $d['Name']; ?></strong><br><code><?php echo $slug; ?></code></td>
                                    <td><?php echo $d['Version']; ?></td>
                                    <td class="col-server">-</td><td class="col-status">Waiting</td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div id="tab-themes" class="digi-tab" style="display:none;">
                        <p><button class="button button-primary" id="btn-check-themes">Kiểm tra</button> <button class="button" id="btn-update-themes" disabled>Cập nhật</button></p>
                        <table class="wp-list-table widefat fixed striped">
                            <thead><tr><td class="check-column"><input type="checkbox" id="cb-all-themes"></td><th>Tên</th><th>Version</th><th>Server</th><th>Status</th></tr></thead>
                            <tbody>
                            <?php foreach($themes as $s => $t): if(is_object($t->parent())) continue; ?>
                                <tr class="item-row" data-type="theme" data-slug="<?php echo $s; ?>" data-ver="<?php echo $t->get('Version'); ?>">
                                    <th class="check-column"><input type="checkbox" class="cb"></th>
                                    <td><strong><?php echo $t->get('Name'); ?></strong><br><code><?php echo $s; ?></code></td>
                                    <td><?php echo $t->get('Version'); ?></td>
                                    <td class="col-server">-</td><td class="col-status">Waiting</td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <div class="notice notice-error inline"><p>Vui lòng kích hoạt License hợp lệ để sử dụng tính năng cập nhật.</p></div>
            <?php endif; ?>
        </div>
        <?php
    }

    public function check_item() {
        check_ajax_referer('digi_update_nonce', 'nonce');
        $license = get_option('digi_client_license_key');
        $res = wp_remote_post( Digi_Client_Config::get_api_url(), array('body'=>array('action'=>'check_update', 'license'=>$license, 'domain'=>home_url(), 'slug'=>$_POST['slug'], 'type'=>$_POST['type'])));
        if(is_wp_error($res)) wp_send_json_error('Error');
        $data = json_decode(wp_remote_retrieve_body($res));
        if(isset($data->error)) wp_send_json_error($data->error);
        if(isset($data->new_version)) wp_send_json_success(array('new'=>$data->new_version, 'pkg'=>$data->download_url, 'has_update'=>version_compare($data->new_version, $_POST['current_version'], '>')));
        wp_send_json_error('Not found');
    }

    public function update_item() {
        check_ajax_referer('digi_update_nonce', 'nonce');
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
        include_once ABSPATH . 'wp-admin/includes/file.php';
        $skin = new WP_Ajax_Upgrader_Skin();
        $upgrader = ($_POST['type']=='plugin') ? new Plugin_Upgrader($skin) : new Theme_Upgrader($skin);
        $result = $upgrader->install($_POST['package_url'], array('overwrite_package'=>true));
        if(is_wp_error($result) || !$result) wp_send_json_error('Failed');
        wp_send_json_success('OK');
    }
}