<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class Digi_Client_Updater {
    public function __construct() {
        add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'check_for_update' ) );
    }
    public function check_for_update( $transient ) {
        if ( empty( $transient->checked ) ) return $transient;
        $license = get_option( 'digi_client_license_key' );
        if ( ! $license ) return $transient;

        $response = wp_remote_post( Digi_Client_Config::get_api_url(), array( 'body' => array(
            'action' => 'check_update', 'license' => $license, 'domain' => home_url(), 'slug' => dirname(DIGI_CLIENT_BASENAME), 'type' => 'plugin'
        )));
        
        if ( ! is_wp_error( $response ) ) {
            $data = json_decode( wp_remote_retrieve_body( $response ) );
            if ( isset( $data->new_version ) ) {
                $curr = get_plugin_data( WP_PLUGIN_DIR . '/' . DIGI_CLIENT_BASENAME )['Version'];
                if ( version_compare( $curr, $data->new_version, '<' ) ) {
                    $obj = new stdClass();
                    $obj->slug = dirname( DIGI_CLIENT_BASENAME );
                    $obj->plugin = DIGI_CLIENT_BASENAME;
                    $obj->new_version = $data->new_version;
                    $obj->package = $data->download_url;
                    $transient->response[ DIGI_CLIENT_BASENAME ] = $obj;
                }
            }
        }
        return $transient;
    }
}